/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'underscore', 'jquerymobile', 'jquerymobile-autocomplete',
    'hbs!applets/wound-care-applet/core/extensions/list-generator/core/views/wards/wardList',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/AutocompleteListView',
    'applets/wound-care-applet/core/extensions/list-generator/core/views/location/LocationView' ],
    function (Portal, Backbone, Marionette, $, _, jqm, jqmAutocomplete, template, AutocompleteListView) {
        'use strict';

        return Portal.module('ListGenerator', function (ListGenerator, Portal, Backbone, Marionette, $, _, template) {
            ListGenerator.WardListView = AutocompleteListView.extend({
                template: template,
                itemView: ListGenerator.LocationView,
                events: {
                    'input .ui-accessible-autocomplete-filter input': 'setLocationFilterText',
                    'change .ui-accessible-autocomplete-filter input': 'setLocationFilter',
                    'tap .ui-accessible-autocomplete-filter a.ui-input-clear': 'clearLocationFilter',
                    'tap ul a': 'preventDefault',
                    'keyup ul a': 'keyupList'
                },
                onRender: function () {
                    var autocompleteCallback = this._autocomplete();

                    this.ui.autocompleteList.accessibleautocomplete({
                        'shadow': true,
                        'selectItem': autocompleteCallback.selectItem,
                        'filterPlaceholder': "Search Wards...",
                        'filterNoItemsMessage': "No Results Found",
											'filterOnPopulateList': true,
											'filterMinLength': 2,
                        'filterReveal': true,
                        'inset': true
                    });
                    this.$el.trigger('create');

                    this.$el.find('.ui-accessible-autocomplete-filter input').val( this.model.get('locationFilter') );
                },
                onShow: function() {
                    this.$el.trigger('create');
                },
                onClose: function() {
                    this.stopListening();
                    this.off();
                },
                setLocationFilterText: function(e) {
                    this.model.set( 'locationFilter', $(e.currentTarget).val() );
                },
                setLocationFilter: function(e) {
                    var activeLiAnchor = this.ui.autocompleteList.find('li.ui-btn-down-d a'),
                        locationFilter = this.model.get('locationFilter').toUpperCase(),
                        liIndex;

                    if (activeLiAnchor.length === 0) {
                        if (this.ui.autocompleteList.find('li:not(.ui-screen-hidden, .ui-li-static)').length > 0) {
                            // switch to _.findIndex after updating to lodash 2.4.1
                            _.find(this.collection.models, function(location, index) {
                                if (location.get('name') === locationFilter) {
                                    liIndex = index + 1;
                                    return true;
                                }
                            });
                            if (typeof liIndex !== 'undefined') {
                                this.ui.autocompleteList.find('li:nth-of-type(' + liIndex +') a').tap();
                            } else {
                                this.model.set( 'location', "" );
                            }
                        } else {
                            this.model.set( 'location', "" );
                        }
                    } else {
                        activeLiAnchor.tap();
                    }
                },
                clearLocationFilter: function(e) {
                    e.preventDefault();
                    this.model.set( 'locationFilter', "" );
                    this.model.set( 'location', "" );
                },
                _autocomplete: function() {
                    var self = this,
                        changeLocation = function(search, item) {
                            var location = self.collection.at(item.index()),
                                locationName;

                            if (self.model.get('location') === "" || location.get('id') !== self.model.get('location').get('id')) {
                                locationName = location.get('name');

                                self.model.set( 'location', location );
                                self.model.set( 'locationFilter', locationName );
                                search.val( locationName );
                            }
                        };

                    return {
                        selectItem: changeLocation
                    };
                }
            });
        }, template);
    });